package ru.yandex.solomon.alert.notification.state;

import java.util.concurrent.CompletableFuture;

import ru.yandex.solomon.alert.notification.channel.Event;
import ru.yandex.solomon.alert.notification.channel.NotificationStatus;

/**
 * @author Vladimir Gordiychuk
 */
class EventProcessingTask {
    private final Event event;
    private final CompletableFuture<NotificationStatus> future;

    public EventProcessingTask(Event event) {
        this(event, new CompletableFuture<>());
    }

    private EventProcessingTask(Event event, CompletableFuture<NotificationStatus> future) {
        this.event = event;
        this.future = future;
    }

    public Event getEvent() {
        return event;
    }

    public CompletableFuture<NotificationStatus> getFuture() {
        return future;
    }
}
