package ru.yandex.solomon.alert.notification.state;

import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.alert.notification.NotificationState;
import ru.yandex.solomon.alert.notification.channel.Event;
import ru.yandex.solomon.alert.notification.channel.NotificationStatus;

import static java.util.concurrent.CompletableFuture.completedFuture;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class PendingState extends AbstractState {

    public PendingState(StateContext context, NotificationState notificationState) {
        super(context, notificationState);
    }

    @Override
    public CompletableFuture<NotificationStatus> process(Event event) {
        NotificationStatus status = ensureNeedsSend(event);
        if (status != null) {
            if (status.getCode() == NotificationStatus.Code.MUTED) {
                if (isNewEvaluationStatus(event) && wasReportedWithSameStatus(event)) {
                    // advance latestSuccessNotify time
                    var next = getNotificationState().toBuilder()
                            .setLatestSuccessNotify(event.getState().getLatestEval())
                            .build();
                    tryChangeState(new PendingState(context, next));
                }
            }
            return completedFuture(status);
        }

        SendingState next = new SendingState(context, getNotificationState(), event);
        if (tryChangeState(next)) {
            return next.sendPreparedMessage();
        } else {
            return processByActualState(event);
        }
    }

    @Override
    public void cancel() {
    }
}
