package ru.yandex.solomon.alert.notification.state;

import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.alert.notification.NotificationState;
import ru.yandex.solomon.alert.notification.channel.Event;
import ru.yandex.solomon.alert.notification.channel.NotificationStatus;

import static java.util.concurrent.CompletableFuture.completedFuture;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class SendingState extends AbstractSendState {
    public SendingState(
            StateContext context,
            NotificationState notificationState,
            Event event)
    {
        this(context, notificationState, new EventProcessingTask(event));
    }

    public SendingState(
            StateContext context,
            NotificationState notificationState,
            EventProcessingTask eventProcessingTask)
    {
        super(context, notificationState, eventProcessingTask);
    }

    @Override
    public CompletableFuture<NotificationStatus> process(Event event) {
        NotificationStatus status = ensureNeedsSend(event);
        if (status != null) {
            return completedFuture(status);
        }

        return delayProcessing(event);
    }

    @Override
    public void cancel() {
        moveToPending(NotificationStatus.OBSOLETE.withDescription("cancel sending"));
    }
}
