package ru.yandex.solomon.alert.notification.state;

import java.util.concurrent.ScheduledExecutorService;

import ru.yandex.solomon.alert.notification.ChannelMetrics;
import ru.yandex.solomon.alert.notification.DispatchRule;
import ru.yandex.solomon.alert.notification.RetryOptions;
import ru.yandex.solomon.alert.notification.channel.NotificationChannel;

/**
 * @author Vladimir Gordiychuk
 */
interface StateContext {
    NotificationChannel getChannel();

    ScheduledExecutorService getExecutorService();

    RetryOptions getRetryOptions();

    ChannelMetrics getMetrics();

    boolean tryChangeState(NotificationChannelState current, NotificationChannelState next);

    NotificationChannelState getCurrentChannelState();

    DispatchRule getDispatchRule();
}
