package ru.yandex.solomon.alert.notification.state;

import java.util.concurrent.CompletableFuture;

import ru.yandex.solomon.alert.notification.NotificationState;
import ru.yandex.solomon.alert.notification.channel.NotificationStatus;
import ru.yandex.solomon.alert.protobuf.TPersistNotificationState;
import ru.yandex.solomon.alert.rule.AlertProcessingState;

/**
 * @author Vladimir Gordiychuk
 */
public interface StatefulNotificationChannel extends AutoCloseable {
    TPersistNotificationState dumpState();

    void restoreState(TPersistNotificationState proto);

    NotificationState getLatestNotificationState();

    CompletableFuture<NotificationStatus> send(AlertProcessingState evaluation);

    @Override
    void close();

    boolean isDefault();
}
