package ru.yandex.solomon.alert.notification.state;

import java.util.concurrent.ScheduledExecutorService;

import ru.yandex.solomon.alert.api.converters.NotificationConverter;
import ru.yandex.solomon.alert.domain.Alert;
import ru.yandex.solomon.alert.domain.ChannelConfig;
import ru.yandex.solomon.alert.notification.NotificationServiceMetrics;
import ru.yandex.solomon.alert.notification.RetryOptions;
import ru.yandex.solomon.alert.notification.channel.NotificationChannel;

/**
 * @author Vladimir Gordiychuk
 */
public class StatefulNotificationChannelFactoryImpl implements StatefulNotificationChannelFactory {
    private final ScheduledExecutorService executorService;
    private final RetryOptions retryOptions;
    private final NotificationConverter notificationConverter;

    public StatefulNotificationChannelFactoryImpl(
        ScheduledExecutorService executorService,
        RetryOptions retryOptions,
        NotificationConverter notificationConverter)
    {
        this.executorService = executorService;
        this.retryOptions = retryOptions;
        this.notificationConverter = notificationConverter;
    }

    @Override
    public StatefulNotificationChannel create(Alert alert, NotificationChannel channel, ChannelConfig alertChannelConfig, NotificationServiceMetrics metrics) {
        return new StatefulNotificationChannelImpl(alert, channel, alertChannelConfig, executorService, retryOptions,
                metrics, notificationConverter);
    }
}
