package ru.yandex.solomon.alert.rule;

import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.alert.mute.domain.AffectingMute;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public record AlertMuteStatus(MuteStatusCode statusCode, List<AffectingMute> affectingMutes) {

    public enum MuteStatusCode {
        UNSPECIFIED(0),
        NOT_MUTED(1),
        PARTLY_MUTED(2),
        MUTED(3),
        ;

        private final int number;

        MuteStatusCode(int number) {
            this.number = number;
        }

        public int getNumber() {
            return number;
        }

        public static MuteStatusCode forNumber(int num) {
            for (MuteStatusCode code : MuteStatusCode.values()) {
                if (code.getNumber() == num) {
                    return code;
                }
            }

            throw new IllegalArgumentException("Not found MuteStatusCode with number: " + num);
        }
    }

    public boolean isMuted() {
        return statusCode == MuteStatusCode.MUTED;
    }

    /**
     * If muteIds are given, returns whether any of them affects this alert (in any state: PENDING, ACTIVE or EXPIRED)
     * If muteIds are empty, returns if alert is muted by some ACTIVE mute
     */
    public boolean containsAnyOf(Set<String> muteIds) {
        if (muteIds.isEmpty()) {
            return isMuted();
        }

        if (affectingMutes.isEmpty()) {
            return false;
        }

        return affectingMutes.stream().anyMatch(aff -> muteIds.contains(aff.muteId()));
    }
}
