package ru.yandex.solomon.alert.rule;

import java.time.Instant;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class AlertRuleDefaultDeadlines implements AlertRuleDeadlines {
    private final long deadline;

    private AlertRuleDefaultDeadlines(Instant deadline) {
        this.deadline = deadline.toEpochMilli();
    }

    public static AlertRuleDeadlines of(Instant deadline) {
        return new AlertRuleDefaultDeadlines(deadline);
    }

    @Override
    public long softResolveDeadline() {
        return 0;
    }

    @Override
    public long softReadDeadline() {
        return 0;
    }

    @Override
    public long hardDeadline() {
        return deadline;
    }
}
