package ru.yandex.solomon.alert.rule;

import com.google.common.collect.ImmutableSet;

import ru.yandex.monlib.metrics.labels.Label;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.alert.domain.Alert;
import ru.yandex.solomon.labels.LabelKeys;
import ru.yandex.solomon.labels.query.Selector;
import ru.yandex.solomon.labels.query.Selectors;
import ru.yandex.solomon.labels.query.SelectorsBuilder;

/**
 * @author Vladimir Gordiychuk
 */
public final class AlertRuleSelectors {

    public static Selectors enrichProjectSelector(Alert alert, Selectors selectors) {
        for (Selector selector : selectors) {
            if (LabelKeys.PROJECT.equals(selector.getKey())) {
                return selectors;
            }
        }

        return selectors.toBuilder()
                .add(Selector.exact(LabelKeys.PROJECT, alert.getProjectId()))
                .build();
    }

    /**
     * @see ru.yandex.solomon.expression.expr.SelExprSelectorsReplaceVisitor#visitSelectors
     * with newFormat = false
     */
    public static Selectors toOldFormat(Selectors newSelectors) {
        var result = Selectors.builder(newSelectors.size() + 1);

        if (!newSelectors.getNameSelector().isEmpty()) {
            result.add(Selector.exact(LabelKeys.SENSOR, newSelectors.getNameSelector()));
        }

        for (Selector selector : newSelectors) {
            result.add(selector);
        }

        return result.build();
    }

    public static Selectors overrideMultiAlertSelector(ImmutableSet<String> groupKeys, Labels groupKey, Selectors selectors) {
        SelectorsBuilder builder = Selectors.builder(selectors.size());
        builder.setNameSelector(selectors.getNameSelector());
        for (Selector selector : selectors) {
            if (!groupKeys.contains(selector.getKey())) {
                builder.add(selector);
            }
        }

        for (String name : groupKeys) {
            Label label = groupKey.findByKey(name);
            final Selector selector;
            if (label == null) {
                selector = Selector.absent(name);
            } else {
                selector = Selector.exact(name, label.getValue());
            }

            builder.add(selector);
        }

        return builder.build();
    }
}
