package ru.yandex.solomon.alert.rule;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.expression.NamedGraphData;
import ru.yandex.solomon.model.protobuf.MetricType;
import ru.yandex.solomon.model.timeseries.AggrGraphDataArrayList;
import ru.yandex.solomon.model.timeseries.AggrGraphDataIterable;
import ru.yandex.solomon.model.timeseries.TimeFilterAggrGraphDataIterator;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class AlertTimeSeries {
    private final String alias;
    private final Labels labels;
    private final MetricType dataType;
    private final AggrGraphDataIterable source;

    public AlertTimeSeries(NamedGraphData ngd) {
        this(ngd.getAlias(), ngd.getLabels(), ngd.getDataType(), ngd.getAggrGraphDataArrayList());
    }

    public AlertTimeSeries(String alias, Labels labels, MetricType dataType, AggrGraphDataIterable source) {
        this.alias = alias;
        this.labels = labels;
        this.dataType = dataType;
        this.source = source;
    }

    public AlertTimeSeries(Labels labels, MetricType dataType, AggrGraphDataIterable source) {
        this("", labels, dataType, source);
    }

    public String getAlias() {
        return alias;
    }

    public Labels getLabels() {
        return labels;
    }

    public MetricType getDataType() {
        return dataType;
    }

    public AggrGraphDataIterable getSource() {
        return source;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AlertTimeSeries that = (AlertTimeSeries) o;
        return Objects.equals(alias, that.alias) &&
                Objects.equals(labels, that.labels) &&
                dataType == that.dataType &&
                AggrGraphDataArrayList.of(source.iterator())
                        .equals(AggrGraphDataArrayList.of(that.source.iterator()));
    }

    @Override
    public int hashCode() {
        return Objects.hash(alias, labels, dataType, source);
    }

    @Override
    public String toString() {
        return "AlertTimeSeries{" +
                "alias='" + alias + '\'' +
                ", labels=" + labels +
                ", dataType=" + dataType +
                ", source=" + source +
                '}';
    }

    public AlertTimeSeries slice(long fromMillis, long toMillis) {
        return new AlertTimeSeries(alias, labels, dataType, TimeFilterAggrGraphDataIterator.slice(source, fromMillis, toMillis));
    }
}
