package ru.yandex.solomon.alert.rule;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import ru.yandex.solomon.alert.template.Template;
import ru.yandex.solomon.alert.template.TemplateFactory;

/**
 * @author Vladimir Gordiychuk
 */
public class AnnotationsTemplate {
    private final Map<String, Template> templateByKey;

    public AnnotationsTemplate(Map<String, String> annotations, TemplateFactory templateFactory) {
        this.templateByKey = compileTemplates(annotations, templateFactory);
    }

    private Map<String, Template> compileTemplates(Map<String, String> keyToTemplate, TemplateFactory templateFactory) {
        if (keyToTemplate.isEmpty()) {
            return Collections.emptyMap();
        }

        Map<String, Template> result = new HashMap<>(keyToTemplate.size());
        for (Map.Entry<String, String> entry : keyToTemplate.entrySet()) {
            result.put(entry.getKey(), templateFactory.createTemplate(entry.getValue()));
        }

        return result;
    }

    public boolean isEmpty() {
        return templateByKey.isEmpty();
    }

    public Map<String, String> process(Map<String, Object> params) {

        // Mustache not support conditions out of the box, but for example
        // datadog support it by the next way:
        // {{#is_match "host.customer" "customer1"}} alert for customer 1 on {{host.name}}  @slack-customer1  {{/is_match}}
        // may be it will be useful add the same extension for us
        Map<String, String> result = new HashMap<>(params.size());
        for (Map.Entry<String, Template> entry : templateByKey.entrySet()) {
            result.put(entry.getKey(), entry.getValue().process(params));
        }

        return result;
    }
}
