package ru.yandex.solomon.alert.rule;

import javax.annotation.Nullable;

import com.google.common.base.Strings;

import ru.yandex.solomon.alert.EvaluationStatus;
import ru.yandex.solomon.metrics.client.MetabaseStatus;
import ru.yandex.solomon.metrics.client.StockpileStatus;

/**
 * @author Vladimir Gordiychuk
 */
public class EvaluationStatusMapping {

    public static EvaluationStatus toEvaluationStatus(MetabaseStatus status, @Nullable String additional) {
        String details = "Metabase - " + status.toString() + " " + Strings.nullToEmpty(additional);
        switch (status.getCode()) {
            case NOT_FOUND:
            case SHARD_NOT_FOUND:
                return EvaluationStatus.NO_DATA.withDescription(details);
            case DEADLINE_EXCEEDED:
                return EvaluationStatus.DEADLINE.withDescription(details);
            case SHARD_NOT_READY:
            case NODE_UNAVAILABLE:
            case RESOURCE_EXHAUSTED:
                return EvaluationStatus.UNAVAILABLE.withDescription(details);
            case SHARD_WRITE_ONLY:
            default:
                return EvaluationStatus.ERROR.withDescription(details);
        }
    }

    public static EvaluationStatus toEvaluationStatus(StockpileStatus status, String additional) {
        String details = "Stockpile - " + status.toString() + " " + Strings.nullToEmpty(additional);
        switch (status.getCode()) {
            case METRIC_NOT_FOUND:
                return EvaluationStatus.NO_DATA.withDescription(details);
            case DEADLINE_EXCEEDED:
                return EvaluationStatus.DEADLINE.withDescription(details);
            case SHARD_NOT_READY:
            case SHARD_ABSENT_ON_HOST:
            case NOTE_ENOUGH_READY_SHARDS:
            case NODE_UNAVAILABLE:
            case RESOURCE_EXHAUSTED:
                return EvaluationStatus.UNAVAILABLE.withDescription(details);
            default:
                return EvaluationStatus.ERROR.withDescription(details);
        }
    }
}
