package ru.yandex.solomon.alert.rule;

import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.alert.EvaluationStatus;
import ru.yandex.solomon.alert.domain.Alert;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class FailedInitAlertRule implements AlertRule {
    private final Alert alert;
    private final Throwable throwable;

    public FailedInitAlertRule(Alert alert, Throwable throwable) {
        this.alert = alert;
        this.throwable = throwable;
    }

    @Nonnull
    @Override
    public String getId() {
        return alert.getId();
    }

    @Nonnull
    @Override
    public Alert getAlert() {
        return alert;
    }

    @Override
    public CompletableFuture<EvaluationStatus> eval(Instant now, AlertRuleDeadlines deadlines) {
        return CompletableFuture.failedFuture(throwable);
    }

    @Override
    public CompletableFuture<ExplainResult> explain(Instant now, AlertRuleDeadlines deadlines) {
        return CompletableFuture.failedFuture(throwable);
    }

    @Override
    public CompletableFuture<SimulationResult> simulate(Instant from, Instant to, Duration gridStep, AlertRuleDeadlines deadlines) {
        return CompletableFuture.failedFuture(throwable);
    }
}
