package ru.yandex.solomon.alert.rule;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.base.MoreObjects;

import ru.yandex.solomon.expression.analytics.GraphDataLoadRequest;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public final class MultipleTimeSeries {
    private final GraphDataLoadRequest request;
    private final List<SingleTimeSeries> timeSeriesList;

    public MultipleTimeSeries(GraphDataLoadRequest request, List<SingleTimeSeries> timeSeriesList) {
        this.request = request;
        this.timeSeriesList = timeSeriesList;
    }

    public GraphDataLoadRequest getRequest() {
        return request;
    }

    public List<SingleTimeSeries> getTimeSeriesList() {
        return timeSeriesList;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("timeSeriesList", timeSeriesList)
                .toString();
    }
}
