package ru.yandex.solomon.alert.rule;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.NamedGraphData;
import ru.yandex.solomon.expression.analytics.GraphDataLoadRequest;
import ru.yandex.solomon.expression.analytics.GraphDataLoader;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public final class PreloadedGraphDataLoader implements GraphDataLoader {
    private final Map<GraphDataLoadRequest, List<SingleTimeSeries>> requestToResponse;

    public PreloadedGraphDataLoader(List<MultipleTimeSeries> responses) {
        this.requestToResponse = new HashMap<>(responses.size());
        for (MultipleTimeSeries response : responses) {
            this.requestToResponse.put(response.getRequest(), response.getTimeSeriesList());
        }
    }

    @Override
    public NamedGraphData[] loadGraphData(GraphDataLoadRequest request) {
        List<SingleTimeSeries> timeSeriesList = requestToResponse.get(request);
        if (timeSeriesList == null) {
            throw new UnsupportedOperationException("Not supported loading data with parameters not known at startup.");
        }

        return timeSeriesList.stream()
                .map(SingleTimeSeries::asNamedGraphData)
                .toArray(NamedGraphData[]::new);
    }
}
