package ru.yandex.solomon.alert.rule;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public enum SimulationStatus {
    UNKNOWN(0),
    OK(1),
    GENERIC_ERROR(2),
    UNSUPPORTED(3),

    NO_SUBALERTS(4),
    NO_METRICS(5),
    TOO_MANY_METRICS(6),

    DATA_LOAD_ERROR(7),
    INVALID_REQUEST(8),
    ;

    private final int number;

    SimulationStatus(int number) {
        this.number = number;
    }

    public int getNumber() {
        return number;
    }

    public SimulationResult withMessage(String message) {
        return new SimulationResult(this, message);
    }
}
