package ru.yandex.solomon.alert.rule;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.base.MoreObjects;

import ru.yandex.solomon.expression.NamedGraphData;
import ru.yandex.solomon.model.MetricKey;
import ru.yandex.solomon.model.protobuf.MetricType;
import ru.yandex.solomon.model.timeseries.AggrGraphDataArrayList;
import ru.yandex.solomon.model.timeseries.AggrGraphDataIterable;


@ParametersAreNonnullByDefault
public final class SingleTimeSeries {
    private final MetricKey metric;
    private final MetricType dataType;
    private final AggrGraphDataIterable iterable;

    public SingleTimeSeries(MetricKey metric, MetricType dataType, AggrGraphDataIterable iterable) {
        this.metric = metric;
        this.dataType = dataType;
        this.iterable = iterable;
    }

    public NamedGraphData asNamedGraphData() {
        return new NamedGraphData("", metric.getType(), metric.getName(), metric.getLabels(), dataType, AggrGraphDataArrayList.of(iterable));
    }

    public AlertTimeSeries castToAlertTimeSeries() {
        return new AlertTimeSeries(metric.getLabels(), dataType, iterable);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("sensor", metric)
                .add("dataType", dataType)
                .add("countPoints", iterable.getRecordCount())
                .toString();
    }
}
