package ru.yandex.solomon.alert.rule;

import java.time.Instant;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.alert.EvaluationStatus;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public interface TemplateProcessor<Result> {
    default ExplainResult processTemplate(Instant now, Result result) {
        return new ExplainResult(processResult(now, result), List.of());
    }

    default ExplainResult processTemplate(Instant now, Result result, List<AlertTimeSeries> series) {
        return new ExplainResult(processResult(now, result), series);
    }

    EvaluationStatus processResult(Instant now, Result result);
}
