package ru.yandex.solomon.alert.rule;

import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.TimeUnit;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class UnrollDeadlines implements AlertRuleDeadlines {
    private final long hardDeadline;
    private final long softDeadline;

    private UnrollDeadlines(Instant now, Duration unrollTimeout) {
        this.softDeadline = now.toEpochMilli() + (unrollTimeout.toMillis() * 5L) / 6L;
        this.hardDeadline = now.toEpochMilli() + unrollTimeout.toMillis();
    }

    public static AlertRuleDeadlines of(Instant now, Duration unrollTimeout) {
        return new UnrollDeadlines(now, unrollTimeout);
    }

    public static AlertRuleDeadlines of(Instant now, long duration, TimeUnit unit) {
        return new UnrollDeadlines(now, Duration.ofMillis(unit.toMillis(duration)));
    }

    @Override
    public long softResolveDeadline() {
        return softDeadline;
    }

    @Override
    public long softReadDeadline() {
        throw new UnsupportedOperationException("read deadlines are not implemented for UnrollDeadlines");
    }

    @Override
    public long hardDeadline() {
        return hardDeadline;
    }
}
