package ru.yandex.solomon.alert.rule.expression;

import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.alert.EvaluationStatus;
import ru.yandex.solomon.expression.expr.SideEffectProcessor;
import ru.yandex.solomon.expression.value.SelValueSideEffect;
import ru.yandex.solomon.expression.value.SelValueStatus;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class EvaluationStatusSideEffectProcessor implements SideEffectProcessor {

    private static final Map<SelValueStatus, EvaluationStatus> SEL_STATUS_TO_EVALUATION_STATUS = Map.of(
            SelValueStatus.UNKNOWN, EvaluationStatus.OK,
            SelValueStatus.OK, EvaluationStatus.OK,
            SelValueStatus.WARN, EvaluationStatus.WARN,
            SelValueStatus.ALARM, EvaluationStatus.ALARM,
            SelValueStatus.NO_DATA, EvaluationStatus.NO_DATA
    );

    private EvaluationStatus status = EvaluationStatus.OK;

    EvaluationStatus getStatus() {
        return status;
    }

    @Override
    public void process(SelValueSideEffect sideEffect) {
        if (sideEffect instanceof SelValueStatus) {
            SelValueStatus status = (SelValueStatus) sideEffect;
            this.status = SEL_STATUS_TO_EVALUATION_STATUS.getOrDefault(status, EvaluationStatus.ERROR.withDescription("SelValueStatus lookup failed"));
        }
    }

}
