package ru.yandex.solomon.alert.rule.expression;

import java.util.stream.Collectors;

import com.google.common.base.MoreObjects;

import ru.yandex.solomon.expression.analytics.GraphDataLoadRequest;
import ru.yandex.solomon.metrics.client.FindResponse;
import ru.yandex.solomon.model.MetricKey;


/**
 * @author Vladimir Gordiychuk
 */
public class ResolvedMetrics {
    private final GraphDataLoadRequest request;
    private final FindResponse findResponse;

    public ResolvedMetrics(GraphDataLoadRequest request, FindResponse findResponse) {
        this.request = request;
        this.findResponse = findResponse;
    }

    public GraphDataLoadRequest getRequest() {
        return request;
    }

    public FindResponse getFindResponse() {
        return findResponse;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("sensors", findResponse.getMetrics()
                        .stream()
                        .map(MetricKey::toString)
                        .collect(Collectors.joining("; ")))
                .toString();
    }
}
