package ru.yandex.solomon.alert.rule.threshold;

import java.util.DoubleSummaryStatistics;
import java.util.function.DoublePredicate;
import java.util.function.ToDoubleFunction;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.alert.domain.threshold.PredicateRule;
import ru.yandex.solomon.alert.domain.threshold.PredicateStatusResult;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
class AggregationWindowCheckFunction extends WindowCheckFunction {
    private final DoublePredicate predicate;
    private final ToDoubleFunction<DoubleSummaryStatistics> aggr;

    AggregationWindowCheckFunction(DoublePredicate predicate, ToDoubleFunction<DoubleSummaryStatistics> aggr, PredicateRule predicateRule) {
        super(predicateRule);
        this.predicate = predicate;
        this.aggr = aggr;
    }

    @Override
    public WindowCheckInstance makeInstance() {
        return new Instance();
    }

    private class Instance extends WindowCheckInstance {

        private long lastTs = 0;
        private DoubleSummaryStatistics summary = new DoubleSummaryStatistics();

        @Override
        public PredicateRule getPredicateRule() {
            return AggregationWindowCheckFunction.this.getPredicateRule();
        }

        @Override
        PredicateStatusResult getResultImpl() {
            double aggregatedValue = aggr.applyAsDouble(summary);
            return new PredicateStatusResult(predicate.test(aggregatedValue), lastTs, aggregatedValue);
        }

        @Override
        boolean consumeImpl(long tsMillis, double value) {
            lastTs = tsMillis;
            summary.accept(value);

            return false;
        }
    }

}
