package ru.yandex.solomon.alert.rule.threshold;

import java.util.function.DoublePredicate;

import ru.yandex.solomon.alert.domain.threshold.PredicateRule;
import ru.yandex.solomon.alert.domain.threshold.PredicateStatusResult;

/**
 * @author Vladimir Gordiychuk
 */
class AtLeastOneWindowCheckFunction extends WindowCheckFunction {
    private final DoublePredicate predicate;

    AtLeastOneWindowCheckFunction(DoublePredicate predicate, PredicateRule predicateRule) {
        super(predicateRule);
        this.predicate = predicate;
    }

    @Override
    public WindowCheckInstance makeInstance() {
        return new Instance();
    }

    private class Instance extends WindowCheckInstance {

        boolean done = false;
        long lastTs = 0;
        double lastVal = Double.NaN;

        @Override
        public PredicateRule getPredicateRule() {
            return AtLeastOneWindowCheckFunction.this.getPredicateRule();
        }

        @Override
        PredicateStatusResult getResultImpl() {
            if (done) {
                // predicate is true somewhere -> triggered
                return PredicateStatusResult.TRIGGERED.withPoint(lastTs, lastVal);
            }
            return PredicateStatusResult.NOT_TRIGGERED.withPoint(lastTs, lastVal);
        }

        @Override
        boolean consumeImpl(long tsMillis, double value) {
            if (predicate.test(value)) {
                done = true;
            }

            lastTs = tsMillis;
            lastVal = value;

            return done;
        }
    }
}
