package ru.yandex.solomon.alert.rule.threshold;

import java.util.function.DoublePredicate;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.alert.domain.threshold.PredicateRule;
import ru.yandex.solomon.alert.domain.threshold.PredicateStatusResult;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
class LastNoNanWindowFunction extends WindowCheckFunction {
    private final DoublePredicate predicate;

    LastNoNanWindowFunction(DoublePredicate predicate, PredicateRule predicateRule) {
        super(predicateRule);
        this.predicate = predicate;
    }

    @Override
    public WindowCheckInstance makeInstance() {
        return new Instance();
    }

    private class Instance extends WindowCheckInstance {

        private double lastValue = Double.NaN;
        private long lastTs = 0;

        @Override
        public PredicateRule getPredicateRule() {
            return LastNoNanWindowFunction.this.getPredicateRule();
        }

        @Override
        boolean consumeImpl(long ts, double value) {
            lastTs = ts;
            lastValue = value;
            return false;
        }

        @Override
        PredicateStatusResult getResultImpl() {
            return new PredicateStatusResult(predicate.test(lastValue), lastTs, lastValue);
        }
    }

}
