package ru.yandex.solomon.alert.rule.threshold;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.alert.domain.threshold.PredicateRule;
import ru.yandex.solomon.alert.domain.threshold.PredicateStatusResult;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public abstract class WindowCheckInstance {
    @Nullable
    private PredicateStatusResult result = null;

    @Nullable
    public PredicateStatusResult consume(long tsMillis, double value) {
        if (result != null) {
            return result;
        }
        if (consumeImpl(tsMillis, value)) {
            result = getResultImpl();
        }
        return result;
    }

    public PredicateStatusResult getResult() {
        if (result != null) {
            return result;
        }

        return result = getResultImpl();
    }

    /*
    * @return true if no more points need to be consumed
    * */
    abstract boolean consumeImpl(long tsMillis, double value);

    abstract PredicateStatusResult getResultImpl();

    abstract public PredicateRule getPredicateRule();
}
