package ru.yandex.solomon.alert.rule.usage;

import java.util.concurrent.TimeUnit;

import ru.yandex.monlib.metrics.MetricConsumer;
import ru.yandex.monlib.metrics.MetricSupplier;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.primitives.Rate;
import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.alert.EvaluationStatus;

/**
 * @author Vladimir Gordiychuk
 */
public class AlertRuleMetrics implements MetricSupplier {
    private final MetricRegistry registry;

    public final Rate evaluations;
    public final Rate readRequests;
    public final Rate readMetrics;
    public final Rate readPoints;
    public final Rate readFailures;
    public final Rate evalFailures;
    public final Rate cpuTimeNanos;

    public AlertRuleMetrics(String projectId) {
        registry = new MetricRegistry(Labels.of("projectId", projectId));
        evaluations = registry.rate("alerting.rule.evaluations");
        readRequests = registry.rate("alerting.rule.read_requests");
        readMetrics = registry.rate("alerting.rule.read_metrics");
        readPoints = registry.rate("alerting.rule.read_points");
        readFailures = registry.rate("alerting.rule.read_failures");
        evalFailures = registry.rate("alerting.rule.eval_failures");
        cpuTimeNanos = new Rate();
        registry.lazyRate("alerting.rule.cpu_use_ms", () -> TimeUnit.NANOSECONDS.toMillis(cpuTimeNanos.get()));
    }

    public void combine(AlertRuleMetrics metrics) {
        evaluations.combine(metrics.evaluations);
        readRequests.combine(metrics.readRequests);
        readMetrics.combine(metrics.readMetrics);
        readPoints.combine(metrics.readPoints);
        readFailures.combine(metrics.readFailures);
        cpuTimeNanos.combine(metrics.cpuTimeNanos);
    }

    @Override
    public int estimateCount() {
        return registry.estimateCount();
    }

    @Override
    public void append(long tsMillis, Labels commonLabels, MetricConsumer consumer) {
        registry.append(tsMillis, commonLabels, consumer);
    }

    public void recordReadFailure(EvaluationStatus status) {
        if (status.getCode() == EvaluationStatus.Code.ERROR) {
            // Analyze getErrorCode()?
            readFailures.inc();
        }
    }

    public void recordEvalFailure() {
        evalFailures.inc();
    }
}
