package ru.yandex.solomon.alert.rule.usage;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

import ru.yandex.monlib.metrics.MetricConsumer;
import ru.yandex.monlib.metrics.MetricSupplier;
import ru.yandex.monlib.metrics.labels.Labels;

/**
 * @author Vladimir Gordiychuk
 */
public class ProjectAlertRuleMetrics implements MetricSupplier {
    private final ConcurrentMap<String, AlertRuleMetrics> metricsByProjectId = new ConcurrentHashMap<>();

    public AlertRuleMetrics of(String projectId) {
        var metrics = metricsByProjectId.get(projectId);
        if (metrics != null) {
            return metrics;
        }

        return metricsByProjectId.computeIfAbsent(projectId, AlertRuleMetrics::new);
    }

    @Override
    public int estimateCount() {
        return 5 * (metricsByProjectId.size() + 1);
    }

    @Override
    public void append(long tsMillis, Labels commonLabels, MetricConsumer consumer) {
        AlertRuleMetrics total = new AlertRuleMetrics("total");
        for (var metrics : metricsByProjectId.values()) {
            metrics.append(tsMillis, commonLabels, consumer);
            total.combine(metrics);
        }
        total.append(tsMillis, commonLabels, consumer);
    }
}
