package ru.yandex.solomon.alert.telegram;

import java.util.List;
import java.util.concurrent.CompletableFuture;

import javax.annotation.Nullable;

import ru.yandex.solomon.alert.telegram.dto.InlineKeyboard;
import ru.yandex.solomon.alert.telegram.dto.ParseMode;
import ru.yandex.solomon.alert.telegram.dto.TelegramSendMessage;
import ru.yandex.solomon.alert.telegram.dto.TelegramUpdate;


/**
 * @author alexlovkov
 **/
public interface TelegramClient extends AutoCloseable {

    CompletableFuture<String> getMe();

    CompletableFuture<List<TelegramUpdate>> getUpdates(long offset, int limit, int timeoutSeconds);

    default CompletableFuture<TelegramSendMessage> sendMessage(long chatId, String text, ParseMode parseMode) {
        return sendMessage(chatId, text, parseMode, null);
    }

    default CompletableFuture<TelegramSendMessage> sendMessage(
        long chatId,
        String text,
        ParseMode parseMode,
        @Nullable InlineKeyboard inlineKeyboard)
    {
        return sendMessage(chatId, text, parseMode, inlineKeyboard, 0);
    }

    default CompletableFuture<TelegramSendMessage> sendMessage(
        long chatId,
        String text,
        ParseMode parseMode,
        long replyMessageId)
    {
        return sendMessage(chatId, text, parseMode, null, replyMessageId);
    }

    CompletableFuture<TelegramSendMessage> forceReply(
            long chatId,
            String text,
            ParseMode parseMode,
            long replyMessageId);

    CompletableFuture<TelegramSendMessage> sendMessage(
        long chatId,
        String text,
        ParseMode parseMode,
        @Nullable InlineKeyboard inlineKeyboard,
        long replyMessageId);

    CompletableFuture<TelegramSendMessage> sendPhoto(
        long chatId,
        byte[] photo,
        @Nullable String captionText,
        @Nullable ParseMode parseMode,
        long replyMessageId,
        @Nullable InlineKeyboard inlineKeyboard);

    default CompletableFuture<TelegramSendMessage> answerCallbackQuery(String callbackId) {
        return answerCallbackQuery(callbackId, null, null, null, null);
    }

    CompletableFuture<TelegramSendMessage> answerCallbackQuery(
        String callbackId,
        @Nullable String text,
        @Nullable Boolean showAlert,
        @Nullable String url,
        @Nullable Integer cacheTimeSeconds);

    CompletableFuture<TelegramSendMessage> editMessageReplyMarkup(
            long chatId,
            long messageId,
            InlineKeyboard inlineKeyboard);

    CompletableFuture<TelegramSendMessage> editMessageText(
            long chatId,
            long messageId,
            String text,
            @Nullable ParseMode parseMode
    );
}
