package ru.yandex.solomon.alert.telegram.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;


/**
 * @author alexlovkov
 **/
@JsonIgnoreProperties(ignoreUnknown = true)
public class CallbackQuery {

    private final String callbackId;
    private final String callbackData;
    private final TelegramMember telegramFrom;
    private final TelegramMessage telegramMessage;

    public CallbackQuery(
        @JsonProperty("id") String callbackId,
        @JsonProperty("data") String callbackData,
        @JsonProperty("from") TelegramMember telegramFrom,
        @JsonProperty("message") TelegramMessage telegramMessage)
    {
        this.callbackId = callbackId;
        this.callbackData = callbackData;
        this.telegramFrom = telegramFrom;
        this.telegramMessage = telegramMessage;
    }

    public String getCallbackId() {
        return callbackId;
    }

    public String getCallbackData() {
        return callbackData;
    }

    public TelegramMember getTelegramFrom() {
        return telegramFrom;
    }

    public TelegramMessage getTelegramMessage() {
        return telegramMessage;
    }

    @Override
    public String toString() {
        return "CallbackQuery{" +
            "callbackId='" + callbackId + '\'' +
            ", callbackData='" + callbackData + '\'' +
            ", telegramFrom=" + telegramFrom +
            ", telegramMessage=" + telegramMessage +
            '}';
    }
}
