package ru.yandex.solomon.alert.telegram.dto;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown = true)
public class ChatMember {
    @Nonnull
    private final String status;
    @Nonnull
    private final TelegramMember user;

    @JsonCreator
    public ChatMember(
            @JsonProperty("status") String status,
            @JsonProperty("user") TelegramMember user)
    {

        this.status = status;
        this.user = user;
    }

    @Nonnull
    public String getStatus() {
        return status;
    }

    @Nonnull
    public TelegramMember getUser() {
        return user;
    }

    @Override
    public String toString() {
        return "ChatMember{" +
                "status='" + status + '\'' +
                ", user=" + user +
                '}';
    }
}
