package ru.yandex.solomon.alert.telegram.dto;

import java.time.Instant;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown = true)
public class ChatMemberUpdated {

    @Nonnull
    private final TelegramChat chat;
    @Nonnull
    private final TelegramMember from;
    @Nonnull
    private final Instant date;
    @Nonnull
    private final ChatMember oldChatMember;
    @Nonnull
    private final ChatMember newChatMember;

    @JsonCreator
    public ChatMemberUpdated(
            @JsonProperty("chat") TelegramChat chat,
            @JsonProperty("from") TelegramMember from,
            @JsonProperty("date") long dateSeconds,
            @JsonProperty("old_chat_member") ChatMember oldChatMember,
            @JsonProperty("new_chat_member") ChatMember newChatMember)
    {

        this.chat = chat;
        this.from = from;
        this.date = Instant.ofEpochSecond(dateSeconds);
        this.oldChatMember = oldChatMember;
        this.newChatMember = newChatMember;
    }

    @Nonnull
    public TelegramChat getChat() {
        return chat;
    }

    @Nonnull
    public TelegramMember getFrom() {
        return from;
    }

    @Nonnull
    public Instant getDate() {
        return date;
    }

    @Nonnull
    public ChatMember getOldChatMember() {
        return oldChatMember;
    }

    @Nonnull
    public ChatMember getNewChatMember() {
        return newChatMember;
    }

    @Override
    public String toString() {
        return "ChatMemberUpdated{" +
                "chat=" + chat +
                ", from=" + from +
                ", date=" + date +
                ", oldChatMember=" + oldChatMember +
                ", newChatMember=" + newChatMember +
                '}';
    }
}
