package ru.yandex.solomon.alert.telegram.dto;

import java.util.ArrayList;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;


/**
 * @author alexlovkov
 * @see <a href="https://core.telegram.org/bots/api#inlinekeyboardmarkup">InlineKeyboardMarkup</a>
 **/
public class InlineKeyboard {
    public static final InlineKeyboard EMPTY = new InlineKeyboard(0);

    @JsonProperty("inline_keyboard")
    @JsonFormat(shape = JsonFormat.Shape.SCALAR)
    private final List<List<Button>> buttons;

    public InlineKeyboard(int numRows) {
        this.buttons = new ArrayList<>(numRows);
        for (int i = 0; i < numRows; i++) {
            buttons.add(new ArrayList<>());
        }
    }

    public List<Button> getRow(int i) {
        return buttons.get(i);
    }
}
