package ru.yandex.solomon.alert.telegram.dto;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.misc.enums.StringEnum;

/**
 * @author Sergey Polovko
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class TelegramChat {

    private final long id;
    private final Type type;

    /**
     * title of the group chat
     */
    @Nullable
    private final String title;

    /**
     * login of user from whom we got a message
     */
    @Nullable
    private final String userName;

    @JsonCreator
    public TelegramChat(
            @JsonProperty("id") long id,
            @JsonProperty("type") Type type,
            @JsonProperty("title") String title,
            @JsonProperty("username") String userName)
    {
        this.id = id;
        this.type = type;
        this.title = title;
        this.userName = userName;
    }

    public long getId() {
        return id;
    }

    public Type getType() {
        return type;
    }

    public String getTitle() {
        return title;
    }

    @Nullable
    public String getUserName() {
        return userName;
    }

    @Override
    public String toString() {
        return "TelegramChat{" +
                "id=" + id +
                ", type=" + type +
                ", title=" + title +
                ", userName=" + userName +
                '}';
    }

    /**
     * TELEGRAM CHAT TYPE
     */
    public enum Type implements StringEnum {
        PRIVATE,
        GROUP,
        SUPERGROUP,
        CHANNEL,
        ;

        private final String value;

        Type() {
            this.value = this.name().toLowerCase();
        }


        @Override
        public String value() {
            return value;
        }
    }
}
