package ru.yandex.solomon.alert.telegram.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;


/**
 * @author alexlovkov
 **/
@JsonIgnoreProperties(ignoreUnknown = true)
public class TelegramMember {

    private final long id;
    private final boolean isBot;
    private final String firstName;
    private final String userName;

    public TelegramMember(
        @JsonProperty("id") long id,
        @JsonProperty("is_bot") boolean isBot,
        @JsonProperty("first_name") String firstName,
        @JsonProperty("username") String userName)
    {
        this.id = id;
        this.isBot = isBot;
        this.firstName = firstName;
        this.userName = userName;
    }

    public long getId() {
        return id;
    }

    public boolean isBot() {
        return isBot;
    }

    public String getFirstName() {
        return firstName;
    }

    public String getUserName() {
        return userName;
    }

    @Override
    public String toString() {
        return "TelegramMember{" +
            "id=" + id +
            ", isBot=" + isBot +
            ", firstName='" + firstName + '\'' +
            ", userName='" + userName + '\'' +
            '}';
    }
}
