package ru.yandex.solomon.alert.telegram.dto;

import java.time.Instant;
import java.util.Objects;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * @author Sergey Polovko
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@ParametersAreNullableByDefault
public class TelegramMessage {

    private final long id;
    private final String text;
    @Nonnull
    private final Instant date;
    @Nonnull
    private final TelegramChat chat;
    private final String newChatTitle;
    private final TelegramMember newChatMember;
    private final TelegramMember leftMember;
    private final TelegramMember telegramFrom;
    /**
     * exists if group was upgrade from group to supergroup
     */
    private final long migrateFromChatId;
    private final TelegramMessage replyToMessage;

    @JsonCreator
    public TelegramMessage(
            @JsonProperty("message_id") long id,
            @JsonProperty("text") String text,
            @JsonProperty("date") long date,
            @JsonProperty("chat") TelegramChat chat,
            @JsonProperty("new_chat_title") String newChatTitle,
            @JsonProperty("new_chat_member") TelegramMember newChatMember,
            @JsonProperty("left_chat_member") TelegramMember leftMember,
            @JsonProperty("from") TelegramMember telegramFrom,
            @JsonProperty("migrate_from_chat_id") long migrateFromChatId,
            @JsonProperty("reply_to_message") TelegramMessage replyToMessage)
    {
        this.id = id;
        this.text = text;
        this.date = Instant.ofEpochSecond(date);
        this.chat = Objects.requireNonNull(chat, "chat");
        this.newChatTitle = newChatTitle;
        this.newChatMember = newChatMember;
        this.leftMember = leftMember;
        this.telegramFrom = telegramFrom;
        this.migrateFromChatId = migrateFromChatId;
        this.replyToMessage = replyToMessage;
    }

    public long getId() {
        return id;
    }

    public String getText() {
        return text;
    }

    @Nonnull
    public Instant getDate() {
        return date;
    }

    @Nonnull
    public TelegramChat getChat() {
        return chat;
    }

    public String getNewChatTitle() {
        return newChatTitle;
    }

    public TelegramMember getNewChatMember() {
        return newChatMember;
    }

    public TelegramMember getLeftMember() {
        return leftMember;
    }

    public TelegramMember getTelegramFrom() {
        return telegramFrom;
    }

    public long getMigrateFromChatId() {
        return migrateFromChatId;
    }

    public TelegramMessage getReplyToMessage() {
        return replyToMessage;
    }

    @Override
    public String toString() {
        return "TelegramMessage{" +
                "id=" + id +
                ", text='" + text + '\'' +
                ", date=" + date +
                ", chat=" + chat +
                ", newChatTitle='" + newChatTitle + '\'' +
                ", newChatMember=" + newChatMember +
                ", leftMember=" + leftMember +
                ", telegramFrom=" + telegramFrom +
                ", migrateFromChatId=" + migrateFromChatId +
                ", replyToMessage=" + replyToMessage +
                '}';
    }
}
