package ru.yandex.solomon.alert.telegram.dto;

import javax.annotation.Nullable;


/**
 * @author alexlovkov
 **/
public class TelegramResponse {

    protected final int code;
    @Nullable
    protected final String description;

    public TelegramResponse(int code) {
        this(code, null);
    }

    public TelegramResponse(int code, @Nullable String description) {
        this.code = code;
        this.description = description;
    }

    @Override
    public String toString() {
        return "TelegramResponse{" +
            "code=" + code +
            ", description='" + description + '\'' +
            '}';
    }

    public int getCode() {
        return code;
    }

    @Nullable
    public String getDescription() {
        return description;
    }

    public boolean isSuccess() {
        return code == 200;
    }
}
