package ru.yandex.solomon.alert.telegram.dto;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;


/**
 * @author Sergey Polovko
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class TelegramSendMessage extends TelegramResponse {

    private final long messageId;

    public TelegramSendMessage(int code) {
        this(code, null);
    }

    public TelegramSendMessage(int code, @Nullable String description) {
        this(code, description, 0);
    }

    public TelegramSendMessage(int code, long messageId) {
        this(code, null, messageId);
    }

    public TelegramSendMessage(int code, @Nullable String description, long messageId) {
        super(code, description);
        this.messageId = messageId;
    }

    public long getMessageId() {
        return messageId;
    }
}
