package ru.yandex.solomon.alert.telegram.dto;

import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * @author Sergey Polovko
 */
@ParametersAreNullableByDefault
@JsonIgnoreProperties(ignoreUnknown = true)
public class TelegramUpdate {

    private final long id;
    private final TelegramMessage message;
    private final CallbackQuery callbackQuery;
    private final ChatMemberUpdated chatMemberUpdated;

    @JsonCreator
    public TelegramUpdate(
            @JsonProperty("update_id") long id,
            @JsonProperty("message") TelegramMessage message,
            @JsonProperty("callback_query") CallbackQuery callbackQuery,
            @JsonProperty("my_chat_member") ChatMemberUpdated chatMemberUpdated)
    {
        this.id = id;
        this.message = message;
        this.callbackQuery = callbackQuery;
        this.chatMemberUpdated = chatMemberUpdated;
    }

    public long getId() {
        return id;
    }

    public TelegramMessage getMessage() {
        return message;
    }

    public CallbackQuery getCallback() {
        return callbackQuery;
    }

    public ChatMemberUpdated getChatMemberUpdated() {
        return chatMemberUpdated;
    }

    @Override
    public String toString() {
        return "TelegramUpdate{" +
            "id=" + id +
            ", message=" + message +
            ", callbackQuery=" + callbackQuery +
            '}';
    }
}
