package ru.yandex.solomon.alert.template;

import java.util.concurrent.CompletableFuture;

import ru.yandex.solomon.alert.protobuf.CreateAlertTemplateRequest;
import ru.yandex.solomon.alert.protobuf.CreateAlertTemplateResponse;
import ru.yandex.solomon.alert.protobuf.DeleteAlertTemplatePublicationRequest;
import ru.yandex.solomon.alert.protobuf.DeleteAlertTemplatePublicationResponse;
import ru.yandex.solomon.alert.protobuf.DeployAlertTemplateRequest;
import ru.yandex.solomon.alert.protobuf.DeployAlertTemplateResponse;
import ru.yandex.solomon.alert.protobuf.ListAlertTemplateRequest;
import ru.yandex.solomon.alert.protobuf.ListAlertTemplateResponse;
import ru.yandex.solomon.alert.protobuf.ListAlertTemplateVersionsRequest;
import ru.yandex.solomon.alert.protobuf.ListAlertTemplateVersionsResponse;
import ru.yandex.solomon.alert.protobuf.PublishAlertTemplateRequest;
import ru.yandex.solomon.alert.protobuf.PublishAlertTemplateResponse;
import ru.yandex.solomon.alert.protobuf.ReadAlertTemplateRequest;
import ru.yandex.solomon.alert.protobuf.ReadAlertTemplateResponse;

/**
 * @author Alexey Trushkin
 */
public interface AlertTemplateService {
    CompletableFuture<CreateAlertTemplateResponse> create(CreateAlertTemplateRequest request);

    CompletableFuture<ReadAlertTemplateResponse> read(ReadAlertTemplateRequest request);

    CompletableFuture<PublishAlertTemplateResponse> publish(PublishAlertTemplateRequest request);

    CompletableFuture<DeleteAlertTemplatePublicationResponse> unpublish(DeleteAlertTemplatePublicationRequest request);

    CompletableFuture<ListAlertTemplateResponse> list(ListAlertTemplateRequest request);

    CompletableFuture<DeployAlertTemplateResponse> deploy(DeployAlertTemplateRequest request);

    CompletableFuture<ListAlertTemplateVersionsResponse> listTemplateVersions(ListAlertTemplateVersionsRequest request);
}
