package ru.yandex.solomon.alert.template;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.WillNotClose;

import com.github.mustachejava.Mustache;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class MustacheTemplate implements Template {
    private final Mustache mustache;

    public MustacheTemplate(Mustache mustache) {
        this.mustache = mustache;
    }

    @Override
    public String process(Map<String, ?> model) {
        StringWriter writer = new StringWriter();
        process(model, writer);
        return writer.toString();
    }

    private void process(Map<String, ?> model, @WillNotClose OutputStream out) {
        process(model, new OutputStreamWriter(out));
    }

    private void process(Map<String, ?> model, @WillNotClose Writer writer) {
        mustache.execute(writer, model);
    }
}
