package ru.yandex.solomon.alert.template;

import java.io.File;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;

import javax.annotation.ParametersAreNonnullByDefault;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.MustacheFactory;
import com.google.common.io.Files;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class MustacheTemplateFactory implements TemplateFactory {
    private final MustacheFactory factory;

    public MustacheTemplateFactory() {
        this(new DefaultMustacheFactory());
    }

    public MustacheTemplateFactory(MustacheFactory factory) {
        this.factory = factory;
    }

    @Override
    public Template createTemplate(String sourceCode) {
        try {
            return new MustacheTemplate(factory.compile(new StringReader(sourceCode), null));
        } catch (Throwable e) {
            throw new RuntimeException("Not able to parse template: " + sourceCode, e);
        }
    }

    @Override
    public Template createTemplateFromFile(String pathToFile) {
        try {
            File file = Paths.get(pathToFile).toFile();
            String content = Files.toString(file, StandardCharsets.UTF_8);
            return createTemplate(content);
        } catch (Throwable e) {
            throw new RuntimeException("Not able parse template by path: " + pathToFile, e);
        }
    }
}
