package ru.yandex.solomon.alert.template.domain;

import java.time.Instant;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnegative;

import ru.yandex.solomon.alert.domain.AlertSeverity;
import ru.yandex.solomon.alert.domain.NoPointsPolicy;
import ru.yandex.solomon.alert.domain.ResolvedEmptyPolicy;

/**
 * @author Alexey Trushkin
 */
public interface AlertTemplate {
    String getTemplateVersionTag();

    String getServiceProviderId();

    String getName();

    String getDescription();

    List<String> getGroupByLabels();

    AlertTemplateType getAlertTemplateType();

    Map<String, String> getAnnotations();

    Map<String, String> getLabels();

    @Nonnegative
    int getPeriodMillis();

    boolean isDefaultTemplate();

    /**
     * Time (in seconds) to delay evaluation relatively now.
     * Useful for delayed metrics like cluster aggregation. Should be a non negative integer.
     */
    @Nonnegative
    int getDelaySeconds();

    ResolvedEmptyPolicy getResolvedEmptyPolicy();

    NoPointsPolicy getNoPointsPolicy();

    /**
     * Compare content ignoring modify attributes(updatedAt, updatedBy, version, etc)
     */
    boolean equalContent(AlertTemplate alert);

    AbstractAlertTemplateBuilder<?, ?> toBuilder();

    List<AlertTemplateParameter> getThresholds();

    List<AlertTemplateParameter> getParameters();

    String getId();

    String getCreatedBy();

    String getUpdatedBy();

    Instant getCreatedAt();

    Instant getUpdatedAt();

    AlertTemplateId getCompositeId();

    AlertSeverity getSeverity();
}
