package ru.yandex.solomon.alert.template.domain;

/**
 * @author Alexey Trushkin
 */
public enum AlertTemplateType {
    /**
     * Threshold are useful for a continuous stream of data. Metrics can be alerted upon
     * if they cross a threshold over a given period of time.
     */
    THRESHOLD(0),

    /**
     * Expression are useful when other alerts type not applicable. And allow fully customisable
     * check via solomon-expression.
     */
    EXPRESSION(1);

    private final int number;

    AlertTemplateType(int number) {
        this.number = number;
    }

    public static AlertTemplateType forNumber(int num) {
        for (AlertTemplateType type : values()) {
            if (type.getNumber() == num) {
                return type;
            }
        }

        throw new IllegalArgumentException("Not found type with number: " + num);
    }

    public int getNumber() {
        return number;
    }
}
