package ru.yandex.solomon.alert.template.domain.expression;

import java.util.Objects;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.base.Strings;

import ru.yandex.solomon.alert.template.domain.AbstractAlertTemplate;
import ru.yandex.solomon.alert.template.domain.AbstractAlertTemplateBuilder;
import ru.yandex.solomon.alert.template.domain.AlertTemplateType;

/**
 * @author Alexey Trushkin
 */
@ParametersAreNonnullByDefault
public class ExpressionAlertTemplate extends AbstractAlertTemplate {
    private final String program;

    protected ExpressionAlertTemplate(ExpressionAlertTemplate.Builder builder) {
        super(builder);
        this.program = Strings.nullToEmpty(builder.program);
    }

    public static ExpressionAlertTemplate.Builder newBuilder() {
        return new ExpressionAlertTemplate.Builder();
    }

    @Override
    public AlertTemplateType getAlertTemplateType() {
        return AlertTemplateType.EXPRESSION;
    }

    @Override
    public ExpressionAlertTemplate.Builder toBuilder() {
        return new ExpressionAlertTemplate.Builder(this);
    }

    public String getProgram() {
        return program;
    }

    @Override
    public String toString() {
        return "ExpressionAlertTemplate{" +
                "program='" + program + '\'' +
                "} : " + super.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExpressionAlertTemplate that = (ExpressionAlertTemplate) o;
        return program.equals(that.program);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), program);
    }

    @ParametersAreNonnullByDefault
    public static class Builder extends AbstractAlertTemplateBuilder<ExpressionAlertTemplate, ExpressionAlertTemplate.Builder> {
        @Nullable
        private String program;

        public Builder() {
        }

        public Builder(ExpressionAlertTemplate alert) {
            super(alert);
            this.program = alert.getProgram();
        }

        public ExpressionAlertTemplate.Builder setProgram(String program) {
            this.program = program;
            return self();
        }

        @Override
        protected ExpressionAlertTemplate.Builder self() {
            return this;
        }

        @Override
        public ExpressionAlertTemplate build() {
            return new ExpressionAlertTemplate(this);
        }
    }
}
