package ru.yandex.solomon.alert.unroll;

import java.util.concurrent.CompletableFuture;

import ru.yandex.solomon.alert.rule.AlertRuleDeadlines;

import static java.util.concurrent.CompletableFuture.failedFuture;

/**
 * @author Vladimir Gordiychuk
 */
public class ExceptionMultipleAlertUnrollFunction implements MultiAlertUnrollFunction {
    private final Throwable exception;

    public ExceptionMultipleAlertUnrollFunction(Throwable exception) {
        this.exception = exception;
    }

    @Override
    public CompletableFuture<UnrollResult> unroll(AlertRuleDeadlines deadlines) {
        return failedFuture(exception);
    }
}
