package ru.yandex.solomon.alert.unroll;

import javax.annotation.Nonnull;

import ru.yandex.solomon.alert.domain.Alert;
import ru.yandex.solomon.alert.domain.AlertType;
import ru.yandex.solomon.alert.domain.expression.ExpressionAlert;
import ru.yandex.solomon.alert.domain.template.AlertFromTemplatePersistent;
import ru.yandex.solomon.alert.domain.threshold.ThresholdAlert;

/**
 * @author Vladimir Gordiychuk
 */
public interface MultiAlertUnrollFactory {

    /**
     * @return true if specified alert should be unroll before evaluate
     */
    static boolean isSupportUnrolling(@Nonnull Alert alert) {
        if (alert.getAlertType() == AlertType.EXPRESSION) {
            ExpressionAlert expressionAlert = (ExpressionAlert) alert;
            return !expressionAlert.getGroupByLabels().isEmpty();
        }

        if (alert.getAlertType() == AlertType.THRESHOLD) {
            ThresholdAlert thresholdAlert = (ThresholdAlert) alert;
            return !thresholdAlert.getGroupByLabels().isEmpty();
        }

        if (alert.getAlertType() == AlertType.FROM_TEMPLATE) {
            AlertFromTemplatePersistent alertFromTemplate = (AlertFromTemplatePersistent) alert;
            return !alertFromTemplate.getGroupByLabels().isEmpty();
        }

        return false;
    }

    /**
     * @throws IllegalArgumentException if specified alert not support unrolling
     */
    @Nonnull
    MultiAlertUnrollFunction create(@Nonnull Alert alert);
}
