package ru.yandex.solomon.alert.unroll;

import javax.annotation.Nonnull;

import ru.yandex.solomon.alert.domain.Alert;
import ru.yandex.solomon.alert.domain.expression.ExpressionAlert;
import ru.yandex.solomon.alert.domain.threshold.ThresholdAlert;
import ru.yandex.solomon.metrics.client.MetricsClient;

/**
 * @author Vladimir Gordiychuk
 */
public class MultiAlertUnrollFactoryImpl implements MultiAlertUnrollFactory {
    private final MetricsClient client;

    public MultiAlertUnrollFactoryImpl(MetricsClient client) {
        this.client = client;
    }

    @Nonnull
    @Override
    public MultiAlertUnrollFunction create(@Nonnull Alert alert) {
        try {
            switch (alert.getAlertType()) {
                case EXPRESSION:
                    return new ExpressionMultiAlertUnroll(client, (ExpressionAlert) alert);
                case THRESHOLD:
                    return new ThresholdMultiAlertUnroll(client, (ThresholdAlert) alert);
                default:
                    throw new IllegalArgumentException("Specified alert not support unrolling: " + alert);
            }
        } catch (Throwable e) {
            return new ExceptionMultipleAlertUnrollFunction(e);
        }
    }
}
