package ru.yandex.solomon.alert.unroll;

import com.google.common.base.Charsets;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.alert.domain.Alert;

/**
 * @author Vladimir Gordiychuk
 */
public final class MultiAlertUtils {
    private MultiAlertUtils() {
    }

    public static String getAlertId(Alert parent, Labels groupKey) {
        return getAlertId(parent.getId(), groupKey);
    }

    /**
     * sha1hex(parentId,labels)
     */
    @SuppressWarnings("CheckReturnValue")
    public static String getAlertId(String parentId, Labels groupKey) {
        Hasher hasher = Hashing.sha1().newHasher()
                .putString(parentId, Charsets.UTF_8);

        groupKey.forEach(label -> {
            hasher.putString(label.getKey(), Charsets.UTF_8);
            hasher.putString(label.getValue(), Charsets.UTF_8);
        });

        return hasher.hash().toString();
    }
}
