package ru.yandex.solomon.alert.unroll;

import ru.yandex.solomon.alert.domain.Alert;

/**
 * @author Vladimir Gordiychuk
 */
public interface UnrollExecutor extends AutoCloseable {
    /**
     * Schedule periodically unroll for alert. First unroll will be delayed.
     */
    void unroll(Alert alert, UnrollConsumer consumer);

    /**
     * Unroll alert first time as fast as possible, and then unroll it periodically
     */
    void unrollNow(Alert alert, UnrollConsumer consumer);

    @Override
    void close();

    interface UnrollConsumer {
        boolean isCanceled();

        /**
         * Evaluates only when list of sub alert changed
         */
        void accept(UnrollResult result);
    }
}
