package ru.yandex.solomon.alert.unroll;

import java.util.Set;

import ru.yandex.monlib.metrics.labels.Labels;

/**
 * @author Vladimir Gordiychuk
 */
public class UnrollResult {
    public static final UnrollResult EMPTY = new UnrollResult(Set.of(), true);

    public final Set<Labels> labels;
    public final boolean allowDelete;

    public UnrollResult(Set<Labels> labels, boolean allowDelete) {
        this.labels = labels;
        this.allowDelete = allowDelete;
    }

    public static UnrollResult of(Set<Labels> labels) {
        return new UnrollResult(labels, true);
    }

    @Override
    public String toString() {
        return "UnrollResult{" +
                "labels=" + labels +
                ", allowDelete=" + allowDelete +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        UnrollResult that = (UnrollResult) o;

        if (allowDelete != that.allowDelete) return false;
        return labels.equals(that.labels);
    }

    @Override
    public int hashCode() {
        int result = labels.hashCode();
        result = 31 * result + (allowDelete ? 1 : 0);
        return result;
    }
}
